package com.ElyStudio.leGaou.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.card.MaterialCardView;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.models.WithdrawMethods;
import com.ElyStudio.leGaou.utilities.Constants;
import com.ElyStudio.leGaou.utilities.OnWithdrawMethodSelect;
import com.squareup.picasso.Picasso;

import java.util.List;

public class WithdrawMethodAdapter extends RecyclerView.Adapter<WithdrawMethodAdapter.WithdrawMethodViewHolder> {

    private List<WithdrawMethods> withdrawMethodsList;
    private Context context;
    private OnWithdrawMethodSelect mCallback;

    public WithdrawMethodAdapter(List<WithdrawMethods> withdrawMethodsList, Context context, OnWithdrawMethodSelect mCallback) {
        this.withdrawMethodsList = withdrawMethodsList;
        this.context = context;
        this.mCallback = mCallback;
    }

    int selectedIndex = 0;

    @NonNull
    @Override
    public WithdrawMethodAdapter.WithdrawMethodViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new WithdrawMethodViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.withdraw_method_layout,parent,false));
    }

    @Override
    public void onBindViewHolder(@NonNull WithdrawMethodAdapter.WithdrawMethodViewHolder holder, int position) {

        WithdrawMethods withdrawMethods = withdrawMethodsList.get(position);

        if(!withdrawMethodsList.get(position).getIcon().trim().equals(""))
        {
            Picasso.get().load(Constants.ADMIN_PANEL_URL + withdrawMethodsList.get(position).getIcon()).into(holder.withdrawMethodIcon);
        }
        if(selectedIndex == position)
        {
            holder.withdrawMethodCard.setStrokeColor(context.getResources().getColor(R.color.primary));
        }
        else
        {
            holder.withdrawMethodCard.setStrokeColor(context.getResources().getColor(R.color.withdraw_method_bg));
        }
        holder.withdrawMethodCard.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                selectedIndex = holder.getAdapterPosition();
                mCallback.onMethodSelected(withdrawMethods.getName(),withdrawMethods.getIdName(),withdrawMethods.getIcon());
                notifyDataSetChanged();
            }
        });

    }

    @Override
    public int getItemCount() {
        return withdrawMethodsList.size();
    }

    public static class WithdrawMethodViewHolder extends RecyclerView.ViewHolder {
        ImageView withdrawMethodIcon;
        MaterialCardView withdrawMethodCard;
        public WithdrawMethodViewHolder(@NonNull View itemView) {
            super(itemView);

            withdrawMethodIcon = itemView.findViewById(R.id.withdrawMethodIcon);
            withdrawMethodCard = itemView.findViewById(R.id.withdrawMethodCard);
        }
    }
}
